package w83b.xml.datatype;

import java.io.Serializable;
import java.util.Locale;

import w83b.w83bUtilidadesComunes.W83bLocaleString;


public class W83bConsultationContext implements Serializable {

	/**
	 * Comment for <code>serialVersionUID</code>
	 */
	private static final long serialVersionUID = 1L;

	public W83bConsultationContext(W83bLocaleString familyName, String organId,
			String departamentId, W83bLocaleString procedureName,
			W83bLocaleString departamentName, W83bLocaleString organName) {

		this.familyName = familyName;
		this.organId = organId;
		this.departamentId = departamentId;
		this.procedureName = procedureName;
		this.departamentName = departamentName;
		this.organName = organName;

	}

	public W83bConsultationContext(String procedureId,
			W83bLocaleString procedureNameLocale, String entityCode,
			String departmentId, W83bLocaleString departmentNameLocale,
			String managingUnitId, W83bLocaleString managingUnitNameLocale/*,
			String managingUnitFunction,
			String managingUnitDeliveryKeyFunction, String familyID,
			String procedureInboxID, String procedureInboxName,
			String certifiedValidationMode, String telematicsCode,
			W83bLocaleString entityNameLocale, String managingUnitInBoxID,
			String telematicActionId, W83bLocaleString telematicActionNameLocale*/) {

		this.procedureId = procedureId;
		this.procedureName = procedureNameLocale;
		this.entityCode = entityCode;
		this.departamentId = departmentId;
		this.departamentName = departmentNameLocale;
		this.organId = managingUnitId;
		this.organName = managingUnitNameLocale;
		/*this.managingUnitFunction = managingUnitFunction;
		this.managingUnitDeliveryKeyFunction = managingUnitDeliveryKeyFunction;
		this.familyID = familyID;
		this.procedureInboxID = procedureInboxID;
		this.procedureInboxName = procedureInboxName;
		this.certifiedValidationMode = certifiedValidationMode;
		this.telematicsCode = telematicsCode;
		this.entityName = entityNameLocale;
		this.managingUnitInBoxId = managingUnitInBoxID;
		this.telematicActionId = telematicActionId;
		this.telematicActionNameLocale = telematicActionNameLocale;*/

	}
		
	public W83bConsultationContext(String procedureId,//NOPMD
			W83bLocaleString procedureNameLocale, String entityCode,
			String departmentId, W83bLocaleString departmentNameLocale,
			String managingUnitId, W83bLocaleString managingUnitNameLocale,
			/*String managingUnitFunction,
			String managingUnitDeliveryKeyFunction, String familyID,
			String procedureInboxID, String procedureInboxName,
			String certifiedValidationMode, String telematicsCode,
			W83bLocaleString entityNameLocale, String managingUnitInBoxID,
			String telematicActionId, W83bLocaleString telematicActionNameLocale, */
			String documentalSeries01Id, String documentalSeries20Id, String documentalSeries48Id, String daProcedureId) {
		
		
	
		this ( procedureId, procedureNameLocale,  entityCode,
				 departmentId,  departmentNameLocale,
				 managingUnitId,  managingUnitNameLocale
				/* managingUnitFunction,
				 managingUnitDeliveryKeyFunction,  familyID,
				 procedureInboxID,  procedureInboxName,
				 certifiedValidationMode,  telematicsCode,
				 entityNameLocale,  managingUnitInBoxID,
				 telematicActionId,  telematicActionNameLocale*/);
	
		this.documentalSeries01Id=documentalSeries01Id;
		this.documentalSeries20Id=documentalSeries20Id;
		this.documentalSeries48Id=documentalSeries48Id;
		this.daProcedureId=daProcedureId;
	}
	

	public W83bLocaleString getProcedureName() {
		return procedureName;
	}

	public String getProcedureNameDesc(String languageCode) {
		return this.procedureName.getString(new Locale(languageCode));
	}

	public void setProcedureName(W83bLocaleString procedureName) {
		this.procedureName = procedureName;
	}

	public W83bLocaleString getDepartamentName() {
		return departamentName;
	}

	public String getDepartamentNameDesc(String languageCode) {
		return this.departamentName.getString(new Locale(languageCode));
	}

	public W83bLocaleString getOrganName() {
		return organName;
	}

	public String getOrganNameDesc(String languageCode) {
		return this.organName.getString(new Locale(languageCode));
	}

	public W83bLocaleString getEntityName() {
		return entityName;
	}

	public String getEntityNameDesc(String languageCode) {
		return this.entityName.getString(new Locale(languageCode));
	}

	public String getDepartamentId() {
		return departamentId;
	}

	public String getOrganId() {
		return organId;
	}

	public W83bLocaleString getFamilyName() {
		return familyName;
	}

	public String getFamilyNameDesc(String languageCode) {
		return this.familyName.getString(new Locale(languageCode));
	}

	//////
	public String getProcedureId() {
		return procedureId;
	}

	public String getEntityId() {
		return entityCode;
	}

	public String getManagingUnitFunction() {
		return managingUnitFunction;
	}

	public String getManagingUnitDeliveryKeyFunction() {
		return managingUnitDeliveryKeyFunction;
	}

	public String getFamilyID() {
		return familyID;
	}

	public String getManagingUnitInboxID() {
		return managingUnitInBoxId;
	}

	public String getProcedureInboxID() {
		return procedureInboxID;
	}

	public String getProcedureInboxName() {
		return procedureInboxName;
	}

	public String getCertifiedValidationMode() {
		return certifiedValidationMode;
	}

	public String getTelematicsCode() {
		return telematicsCode;
	}

//	private static Logger log = Logger.getLogger(W83bConsultationContext.class
//			.getName());

	/**
	 * @return Returns the telematicActionId.
	 */
	public String getTelematicActionId() {
		return telematicActionId;
	}

	/**
	 * @param telematicActionId
	 *            The telematicActionId to set.
	 */
	public void setTelematicActionId(String telematicActionId) {
		this.telematicActionId = telematicActionId;
	}

	/**
	 * @return Returns the telematicActionNameLocale.
	 */
	public W83bLocaleString getTelematicActionNameLocale() {
		return telematicActionNameLocale;
	}

	/**
	 * @param telematicActionNameLocale
	 *            The telematicActionNameLocale to set.
	 */
	public void setTelematicActionNameLocale(
			W83bLocaleString telematicActionNameLocale) {
		this.telematicActionNameLocale = telematicActionNameLocale;
	}
	
	/**
	 * @return the documentalSeries01Id
	 */
	public String getDocumentalSeries01Id() {
		return documentalSeries01Id;
	}

	/**
	 * @return the documentalSeries20Id
	 */
	public String getDocumentalSeries20Id() {
		return documentalSeries20Id;
	}

	/**
	 * @return the documentalSeries48Id
	 */
	public String getDocumentalSeries48Id() {
		return documentalSeries48Id;
	}	
	
	

	public String getDaProcedureId() {
		return daProcedureId;
	}



	private W83bLocaleString procedureName;

	private W83bLocaleString departamentName;

	private String departamentId;

	private W83bLocaleString organName;

	private String organId;

	private W83bLocaleString familyName;

	private String entityCode;

	//
	private String procedureId;

	private String managingUnitInBoxId;

	private String managingUnitFunction;

	private String managingUnitDeliveryKeyFunction;

	private String familyID;

	private String procedureInboxID;

	private String procedureInboxName;

	private String certifiedValidationMode;

	private String telematicsCode;

	private W83bLocaleString entityName;

	private String telematicActionId;

	private W83bLocaleString telematicActionNameLocale;
	
	//adaptacion platea v2.1
	private String documentalSeries01Id, documentalSeries20Id, documentalSeries48Id;
	
	private String daProcedureId;

}